﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class WriteFilePanel
    Inherits FileSystemSample.TaskPanelBase

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents FileContentsTextBox As System.Windows.Forms.TextBox
    Friend WithEvents Label1 As System.Windows.Forms.Label

    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        Me.FileContentsTextBox = New System.Windows.Forms.TextBox
        Me.Label1 = New System.Windows.Forms.Label
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.Text = "When writing files infrequently, the My.Computer.WriteAllText can be used to writ" & _
            "e the file in a single of code!"
        '
        'ExececuteMethodButton
        '
        '
        'ResetValuesButton
        '
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.Label1)
        Me.GroupBox2.Controls.Add(Me.FileContentsTextBox)
        Me.GroupBox2.Controls.SetChildIndex(Me.EndParenLabel, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ExececuteMethodButton, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ResetValuesButton, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.FileContentsTextBox, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.Label1, 0)
        '
        'FileContentsTextBox
        '
        Me.FileContentsTextBox.AutoSize = False
        Me.FileContentsTextBox.Location = New System.Drawing.Point(28, 209)
        Me.FileContentsTextBox.Multiline = True
        Me.FileContentsTextBox.Name = "FileContentsTextBox"
        Me.FileContentsTextBox.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.FileContentsTextBox.Size = New System.Drawing.Size(539, 178)
        Me.FileContentsTextBox.TabIndex = 5
        '
        'Label1
        '
        Me.Label1.AutoSize = True
        Me.Label1.Location = New System.Drawing.Point(28, 188)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(99, 14)
        Me.Label1.TabIndex = 6
        Me.Label1.Text = "Text to write to file:"
        '
        'WriteFilePanel
        '
        Me.Name = "WriteFilePanel"
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Shared panelInstance As WriteFilePanel
    Friend WithEvents writeFileFileChooser As New FileChooser()
    Friend WithEvents appendComboBox As New ComboBox()
    Friend WithEvents encodingComboBox As New ComboBox()

    ''' <summary>
    ''' 获取该面板的全局实例
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As WriteFilePanel
        If (panelInstance Is Nothing) Then
            panelInstance = New WriteFilePanel
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板，并为 WriteAllText 的每个参数添加一个控件
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ReadFile_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("filename", writeFileFileChooser)
        MyBase.AddParameter("append", appendComboBox)
        MyBase.AddParameter("encoding", encodingComboBox)
    End Sub

    ''' <summary>
    ''' 将每个控件初始化为其默认值
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.WriteAllText("
        writeFileFileChooser.Reset()
        appendComboBox.Items.AddRange(New String() {"True", "False"})
        appendComboBox.AutoSize = True
        appendComboBox.SelectedItem = "True"

        encodingComboBox.Items.AddRange(New String() {"ASCII", "BigEndianUnicode", "Unicode", "UTF7", "UTF8", "UTF32"})
        encodingComboBox.AutoSize = True
        encodingComboBox.SelectedItem = "ASCII"
    End Sub

    ''' <summary>
    ''' 将 TextBox 中的文本写入一个文件
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        Try
            My.Computer.FileSystem.WriteAllText( _
                                            file:=writeFileFileChooser.Filename, _
                                            text:=Me.FileContentsTextBox.Text, _
                                            append:=Boolean.Parse(CType(appendComboBox.SelectedItem, String)), _
                                            encoding:=ParseEncoding(CType(Me.encodingComboBox.SelectedItem, String)))
            Me.FileContentsTextBox.Text = String.Empty
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ''' <summary>
    ''' 将这些控件值重置为其初始状态
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub

End Class
